#include <Arduino.h>
#include "HX711.h"

// HX711 circuit wiring
const int LOADCELL_DOUT_PIN = 7;  // ESP32-C3 pin 7 connected to HX711 data
const int LOADCELL_SCK_PIN = 6;   // ESP32-C3 pin 6 connected to HX711 clock

HX711 scale;

void setup() {
  Serial.begin(115200);
  while (!Serial); // Wait for serial connection for boards with native USB
  
  Serial.println("Initializing the scale");
  
  scale.begin(LOADCELL_DOUT_PIN, LOADCELL_SCK_PIN);

  Serial.println("Before setting up the scale:");
  Serial.print("read: \t\t");
  Serial.println(scale.read());      // print a raw reading from the ADC

  Serial.print("read average: \t\t");
  Serial.println(scale.read_average(20));   // print the average of 20 readings from the ADC

  Serial.print("get value: \t\t");
  Serial.println(scale.get_value(5));   // print the average of 5 readings minus the tare weight (not set yet)

  Serial.print("get units: \t\t");
  Serial.println(scale.get_units(5), 1);  // print the average of 5 readings minus tare weight (not set) divided 
                                            // by the SCALE parameter (not set yet)

  scale.set_scale(2280.f);                      // this value is obtained by calibrating the scale with known weights
  scale.tare();                               // reset the scale to 0

  Serial.println("After setting up the scale:");
  Serial.print("read: \t\t");
  Serial.println(scale.read());                 // print a raw reading from the ADC

  Serial.print("read average: \t\t");
  Serial.println(scale.read_average(20));       // print the average of 20 readings from the ADC

  Serial.print("get value: \t\t");
  Serial.println(scale.get_value(5));           // print the average of 5 readings minus the tare weight (not set yet)

  Serial.print("get units: \t\t");
  Serial.println(scale.get_units(5), 1);        // print the average of 5 readings minus tare weight (not set) divided 
                                            // by the SCALE parameter (not set yet)

  Serial.println("Readings:");
}

void loop() {
  Serial.print("Weight: ");
  Serial.print(scale.get_units(10), 1); // Get 10 readings and average them, then display with 1 decimal place
  Serial.println(" kg");

  delay(1000); // Wait 1 second between readings
}

void calibrate() {
  Serial.println("Calibration mode");
  Serial.println("Remove all weight from the scale");
  Serial.println("After readings begin, place a known weight on the scale");
  Serial.println("Press + or a to increase calibration factor");
  Serial.println("Press - or z to decrease calibration factor");
  Serial.println("Press t to tare");
  Serial.println("Press s to save calibration factor to EEPROM");
  
  scale.set_scale();  // reset scale to default
  scale.tare();       // reset tare
  
  float calibration_factor = 2000.f; // initial guess
  scale.set_scale(calibration_factor);
  
  while (true) {
    if (Serial.available()) {
      char c = Serial.read();
      if (c == '+' || c == 'a') {
        calibration_factor += 10;
        scale.set_scale(calibration_factor);
      } else if (c == '-' || c == 'z') {
        calibration_factor -= 10;
        scale.set_scale(calibration_factor);
      } else if (c == 't') {
        scale.tare();
      } else if (c == 's') {
        // Save to EEPROM if needed
        break;
      }
    }
    
    Serial.print("Reading: ");
    float reading = scale.get_units(5);
    Serial.print(reading, 3);
    Serial.print(" units | Calibration factor: ");
    Serial.print(calibration_factor);
    Serial.println();
    
    delay(200);
  }
}